using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace MessageBoard {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry

        // czcionka uywana do wywietlania komunikatu
        SpriteFont font;

        // tekstura ta i prostokt
        Texture2D gameTexture;
        Rectangle spriteRect;

        // wywietlany komunikat
        // acuch pocztkowo jest pusty
        string messageString = "";

        // klawisze nacinite wczeniej (ta tablica pocztkowo jest pusta)
        Keys[] oldKeys = new Keys[0];

        // wartoci opisujce kolory animacji
        byte redIntensity = 0;
        bool redCountingUp = true;
        byte redUpdateLimit = 3;
        byte redUpdateCount = 0;

        byte greenIntensity = 0;
        bool greenCountingUp = true;
        byte greenUpdateLimit = 5;
        byte greenUpdateCount = 0;

        byte blueIntensity = 0;
        bool blueCountingUp = true;
        byte blueUpdateLimit = 7;
        byte blueUpdateCount = 0;

        public Game1() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa zasoby inne ni graficzne.
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            spriteRect = new Rectangle(
                    0, // wsprzdna pozioma lewego, grnego rogu
                    0, // wsprzdna pionowa lewego, grnego rogu
                    GraphicsDevice.Viewport.Width, // szeroko prostokta
                    GraphicsDevice.Viewport.Height); // wysoko prostokta

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            font = Content.Load<SpriteFont > ("SpriteFont1");
            gameTexture = Content.Load<Texture2D > ("MoodSquares");
        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            // Umoliwia wyjcie z gry.
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            KeyboardState keyState = Keyboard.GetState();

            // Umoliwia wyjcie z gry po naciniciu klawisza Esc.
            if (keyState.IsKeyDown(Keys.Escape)) {
                this.Exit();
            }

            // aktualnie wcinite klawisze
            Keys[] pressedKeys;
            pressedKeys = keyState.GetPressedKeys();

            // przeszukuje kolejno wszystkie aktualnie wcinite klawisze
            for (int i = 0; i < pressedKeys.Length; i++) {
                // ustawia flag okrelajc, e nie znaleziono klawisza
                bool foundIt = false;

                // przeszukuje kolejno wszystkie poprzednio wcinite klawisze
                for (int j = 0; j < oldKeys.Length; j++) {
                    if (pressedKeys[i] == oldKeys[j]) {
                        // znaleziono klawisz w tablicy wczeniej wcinitych klawiszy
                        foundIt = true;
                    }
                }
                if (foundIt == false) {
                    // skoro sterowanie trafio w to miejsce, nie znaleziono klawisza w tablicy poprzednio wcinitych klawiszy,
                    // naley zdekodowa warto klawisza, aby wygenerowa odpowiedni komunikat
                    string keyString = ""; // ten acuch pocztkowo jest pusty
                    switch (pressedKeys[i]) {
                        case Keys.D0:
                            keyString = "0";
                            break;
                        case Keys.D1:
                            keyString = "1";
                            break;
                        case Keys.D2:
                            keyString = "2";
                            break;
                        case Keys.D3:
                            keyString = "3";
                            break;
                        case Keys.D4:
                            keyString = "4";
                            break;
                        case Keys.D5:
                            keyString = "5";
                            break;
                        case Keys.D6:
                            keyString = "6";
                            break;
                        case Keys.D7:
                            keyString = "7";
                            break;
                        case Keys.D8:
                            keyString = "8";
                            break;
                        case Keys.D9:
                            keyString = "9";
                            break;
                        case Keys.A:
                            keyString = "A";
                            break;
                        case Keys.B:
                            keyString = "B";
                            break;
                        case Keys.C:
                            keyString = "C";
                            break;
                        case Keys.D:
                            keyString = "D";
                            break;
                        case Keys.E:
                            keyString = "E";
                            break;
                        case Keys.F:
                            keyString = "F";
                            break;
                        case Keys.G:
                            keyString = "G";
                            break;
                        case Keys.H:
                            keyString = "H";
                            break;
                        case Keys.I:
                            keyString = "I";
                            break;
                        case Keys.J:
                            keyString = "J";
                            break;
                        case Keys.K:
                            keyString = "K";
                            break;
                        case Keys.L:
                            keyString = "L";
                            break;
                        case Keys.M:
                            keyString = "M";
                            break;
                        case Keys.N:
                            keyString = "N";
                            break;
                        case Keys.O:
                            keyString = "O";
                            break;
                        case Keys.P:
                            keyString = "P";
                            break;
                        case Keys.Q:
                            keyString = "Q";
                            break;
                        case Keys.R:
                            keyString = "R";
                            break;
                        case Keys.S:
                            keyString = "S";
                            break;
                        case Keys.T:
                            keyString = "T";
                            break;
                        case Keys.U:
                            keyString = "U";
                            break;
                        case Keys.W:
                            keyString = "W";
                            break;
                        case Keys.V:
                            keyString = "V";
                            break;
                        case Keys.X:
                            keyString = "X";
                            break;
                        case Keys.Y:
                            keyString = "Y";
                            break;
                        case Keys.Z:
                            keyString = "Z";
                            break;
                        case Keys.Space:
                            keyString = " ";
                            break;
                        case Keys.OemPeriod:
                            keyString = ".";
                            break;
                        case Keys.Enter:
                            keyString = "\n";
                            break;

                    }

                    if (keyState.IsKeyUp(Keys.LeftShift) && keyState.IsKeyUp(Keys.RightShift)) {
                        keyString = keyString.ToLower();
                    }

                    if (pressedKeys[i] == Keys.Back) {
                        if (messageString.Length > 0) {
                            messageString = messageString.Remove(messageString.Length - 1, 1);
                        }
                    }

                    messageString = messageString + keyString;
                }
            }

            // zapamituje klawisze na potrzeby nastpnego wywoania
            oldKeys = pressedKeys;

            // Aktualizuje kolejno wszystkie barwy
            redUpdateCount++;
            if (redUpdateCount == redUpdateLimit) {
                if (redCountingUp) redIntensity++;
                else redIntensity--;
                if (redIntensity == 255) redCountingUp = false;
                if (redIntensity == 0) redCountingUp = true;
                redUpdateCount = 0;
            }

            greenUpdateCount++;
            if (greenUpdateCount == greenUpdateLimit) {
                if (greenCountingUp) greenIntensity++;
                else greenIntensity--;
                if (greenIntensity == 255) greenCountingUp = false;
                if (greenIntensity == 0) greenCountingUp = true;
                greenUpdateCount = 0;
            }

            blueUpdateCount++;
            if (blueUpdateCount == blueUpdateLimit) {
                if (blueCountingUp) blueIntensity++;
                else blueIntensity--;
                if (blueIntensity == 255) blueCountingUp = false;
                if (blueIntensity == 0) blueCountingUp = true;
                blueUpdateCount = 0;
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            Color backgroundColor;
            backgroundColor = new Color(redIntensity, greenIntensity, blueIntensity);

            string displayString = messageString + "\n" + DateTime.Now.ToLongTimeString();
            Vector2 nowVector = new Vector2(50, 50);
            int layer;

            spriteBatch.Begin();

            spriteBatch.Draw(gameTexture, spriteRect, backgroundColor);

            // Rysuje cie
            Color nowColor = new Color(0, 0, 0, 20);
            for (layer = 0; layer < 10; layer++) {
                spriteBatch.DrawString(font, displayString, nowVector, nowColor);
                nowVector.X++;
                nowVector.Y++;
            }

            // Rysuje podstaw znakw
            nowColor = new Color(190, 190, 190);
            for (layer = 0; layer < 5; layer++) {
                spriteBatch.DrawString(font, displayString, nowVector, nowColor);
                nowVector.X++;
                nowVector.Y++;
            }

            // Rysuje przedni cz znakw
            spriteBatch.DrawString(font, displayString, nowVector, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}

